
/**********************************************************************************
 Persistence of Vision Ray Tracer Scene Description File
 File name   : Janets trick.pov
 Version     : 3.6.1c / MegaPOV 1.21
 Description : First Janet's example, based on trick described second, below.
               
 Date        : 29 October 2006
 Author      : Janet aka parrotdolphin
 E-mail      : p.b.i. and http://www.deviantart.com/deviation/41482649/ 
 
 Copyright (C) 2006. All rights reserved.
 Use and/or modification of this scene is free, except for commercial purposes.
 Commercial distribution is not allowed without written permission from the author.
**********************************************************************************/

// Render settings (right-click on line below):
// +w500 +h500 +a0.3 +am2


/*Note
This is a dish modelled in Blender. The pattern on it uses a pigment_pattern
to add a gold texture to parts of the pattern. Its a very handy trick. This
is the code for the pattern on the top of the dish.*/

/*
//This is the color image
#declare p_map1 = 
pigment {
  uv_mapping 
  image_map {jpeg "ChineseSquareDishTex1.jpg" interpolate 2
  } 
}

//This is a gray scale image to define the textures
#declare p_mapPM = 
pigment {
  uv_mapping 
  image_map {jpeg "ChineseSquareDishTexPimentMap.jpg" interpolate 2
  } 
}

#declare GoldBase = <1.00, 0.875, 0.575>;  // mine again  rgb<1.00, 0.775, 0.375>
#declare CVect3 = GoldBase  - <0.00, 0.10, 0.20>;
#declare P_Gold3 = rgb CVect3;
#declare A_GoldC = P_Gold3 * 0.08 + 0.1;
#declare R_GoldC = P_Gold3 * 0.40 + 0.25;
#declare D_GoldC = 1 - (((R_GoldC.red + R_GoldC.green + R_GoldC.blue)/3) + ((A_GoldC.red + A_GoldC.green + A_GoldC.blue)/3));
#declare M = 1;

#declare F_MetalC = 
finish {
  brilliance 4 
  diffuse D_GoldC 
  ambient A_GoldC
  reflection R_GoldC
  metallic M 
  specular 0.60 
  roughness 1/80 
}

#declare FIN = 
finish {
  phong 1 
  phong_size 30 
  diffuse 0.6*1 
  ambient rgb <0,0,0> 
  reflection {.05}
}

texture {
  pigment_pattern {p_mapPM }
  texture_map {
     [0   pigment { p_map1 } finish{ FIN } ]
     [.9  pigment { p_map1 } finish{ FIN } ]
     [.99 pigment { rgb GoldBase } finish  { F_MetalC } ]
     [1   pigment { rgb GoldBase } finish  { F_MetalC } ]
  }
}
*/
//=====================================================================================================================================
//It is based on the following example by parrotdolphin at http://www.deviantart.com/deviation/41482649/ :

/*Artist's Comments 
This is an experiment using POV-Ray's pigment_pattern feature. It uses square grayscale images to vary the textures on the 2 cylinders. 
I put the images to the left and right so you can see what was used. Basically, it takes the gray value to determine which texture to use. 
It will average the textures, as is the case on the left, when there is a smooth transition. I will try this with uv mapping on some model too. */

//Here's the code for the cylinders: 


//Just some declares for the gold texture, which isn't even gold
#declare GoldBase = <1.00, 0.875, 0.575>; 
#declare CVect3 = GoldBase - <0.00, 0.10, 0.20>; 
#declare P_Gold3 = rgb CVect3;
#declare A_GoldC = P_Gold3 * 0.08 + 0.1;
#declare R_GoldC = P_Gold3 * 0.40 + 0.25;
#declare D_GoldC = 1 - (((R_GoldC.red + R_GoldC.green + R_GoldC.blue)/3) + ((A_GoldC.red + A_GoldC.green + A_GoldC.blue)/3)); 
#declare M = 1; 
#declare F_MetalC = 
finish {
  brilliance 4 
  diffuse D_GoldC 
  ambient A_GoldC 
  reflection R_GoldC
  metallic M 
  specular 0.60 
  roughness 1/80 
}

#declare p_map1 = pigment {image_map {jpeg "GrayGradSharp.jpg" map_type 2 once } } 
#declare p_map2 = pigment {image_map {jpeg "GrayGradBlurred.jpg" map_type 2 once } }

cylinder { <0, 0, 0>, <0, 1, 0>, .25 
  texture { 
    pigment_pattern {p_map2 } 
    texture_map {
      [0.00 pigment {crackle
              color_map {
                [0.00 rgb < 0 , 1 , 0>]
                [0.33 rgb < 0 , 0 , 1>]
                [0.66 rgb < 0 , 1 , 1>]
                [1.00 rgb < 1 , 1 , 0>]
              } 
              scale .025 
              turbulence .25 
            }
            finish {reflection .5} ] 
      [0.25 pigment {bozo
              color_map {
                [0.00 rgb < 1 , 1 , 0>]
                [0.33 rgb < 1 , 0 , 1>]
                [0.66 rgb < 0 , 1 , 1>]
                [1.00 rgb < 1 , 1 , 0>]
              } 
              scale .05 
              turbulence .5 
            }
            finish {specular 0.5} 
            normal {bumps scale .001 turbulence 1} ] 
      [0.50 pigment { rgb<0,1,0> } 
            finish { F_MetalC } 
            normal { crackle scale .1 turbulence 1 } ] 
      [0.75 pigment {agate
              color_map {
                [0.0 rgb <.8,.9,1>*1.5]
                [0.45 rgb <.8,.9,1>*.95]
                [0.50 rgb <.8,.9,1>*.4]
                [0.65 rgb <.8,.9,1>*.95]
                [1.0 rgb <.8,.9,1>*1.5]
              } 
              scale .2 
              turbulence .001 
            }
            finish { phong .5 phong_size 30 specular 0.9}
            normal { quilted scale .005 turbulence .5 } ]
      [1.00 pigment {marble
              color_map {
                [0.0 rgb < 1 , 0 , 0>]
                [0.2 rgb < 1 , .5 , 0>]
                [0.4 rgb < .5 , 1 , 0>]
                [0.6 rgb < 1 , 1 , 0>]
              } 
              scale .1 
              turbulence .2 
            }
            finish { F_MetalC } 
            normal { bumps scale .005 turbulence 1 } ] 
    } 
  } 
  translate x*-.3 
} 


cylinder { <0, 0, 0>, <0, 1, 0>, .25 
  texture { 
    pigment_pattern { p_map1 } 
    texture_map {
      [0.00 pigment {crackle
              color_map {
                [0.00 rgb < 0 , 1 , 0>]
                [0.33 rgb < 0 , 0 , 1>]
                [0.66 rgb < 0 , 1 , 1>]
                [1.00 rgb < 1 , 1 , 0>]
              } 
              scale .025 
              turbulence .25 
            }
            finish { reflection .5} ] 
      [0.25 pigment {bozo
              color_map {
                [0.00 rgb < 1 , 1 , 0>]
                [0.33 rgb < 1 , 0 , 1>]
                [0.66 rgb < 0 , 1 , 1>]
                [1.00 rgb < 1 , 1 , 0>]
              } 
              scale .05 
              turbulence .5 
            }
            finish { specular 0.5} 
            normal { bumps scale .001 turbulence 1 } ] 
      [0.50 pigment { rgb<0,1,0> } 
            finish { F_MetalC } 
            normal { crackle scale .1 turbulence 1 } ] 
      [0.75 pigment {agate
              color_map {
                [0.0 rgb <.8,.9,1>*1.5]
                [0.45 rgb <.8,.9,1>*.95]
                [0.50 rgb <.8,.9,1>*.4]
                [0.65 rgb <.8,.9,1>*.95]
                [1.0 rgb <.8,.9,1>*1.5]
              } 
              scale .2 
              turbulence .001 
            }
            finish { phong .5 phong_size 30specular 0.9}
            normal { quilted scale .005 turbulence .5 } ]
      [1.00 pigment {marble
              color_map {
                [0.0 rgb < 1 , 0 , 0>]
                [0.2 rgb < 1 , .5 , 0>]
                [0.4 rgb < .5 , 1 , 0>]
                [0.6 rgb < 1 , 1 , 0>]
              } 
              scale .1 
              turbulence .2 
            }
            finish { F_MetalC } 
            normal { bumps scale .005 turbulence 1 } ] 
    } 
  } 
  translate x*.3
} 

//================================================================================================================

#version 3.6;

#include "colors.inc"

global_settings {
  assumed_gamma 1.0
}

// ----------------------------------------

camera {
  location  <0.0, 0.5, -2.0>
  direction 1.5*z
  right     x*image_width/image_height
  look_at   <0.0, 0.5,  0.0>
}

sky_sphere {
  pigment {
    gradient y
    color_map {
      [0.0 rgb <0.6,0.7,1.0>]
      [0.7 rgb <0.0,0.1,0.8>]
    }
  }
}

light_source {
  <0, 0, 0>            // light's position (translated below)
  color rgb <1, 1, 1>  // light's color
  translate <-30, 30, -30>
}

// ----------------------------------------

plane {
  y, 0
  pigment { color rgb <0.7,0.5,0.3> }
}

